﻿using System.IO;
using System.Text;
using System.Text.Json;

namespace LocalAI
{
    public class RagConfig
    {
        public int MaxChunkSize { get; set; } = 600;
        public int MaxChunksPerArticle { get; set; } = 3;
        public int MaxTotalChunks { get; set; } = 10;

        public int TopK { get; set; } = 1;
        public int MinRelevanceScore { get; set; } = 15; // Prozent
        public int MaxSentences { get; set; } = 2;

        public static RagConfig Load(string path = "ragconfig.json")
        {
            if (!File.Exists(path))
                return new RagConfig();

            string json = File.ReadAllText(path);

            return System.Text.Json.JsonSerializer.Deserialize<RagConfig>(json)
                   ?? new RagConfig();
        }

        public string Dump()
        {
            var sb = new StringBuilder();
            sb.AppendLine("=== RagConfig ===");
            sb.AppendLine($"MaxChunkSize        = {MaxChunkSize}");
            sb.AppendLine($"MaxChunksPerArticle = {MaxChunksPerArticle}");
            sb.AppendLine($"MaxTotalChunks      = {MaxTotalChunks}");
            sb.AppendLine($"TopK                = {TopK}");
            sb.AppendLine($"MinRelevanceScore   = {MinRelevanceScore}");
            sb.AppendLine($"MaxSentences        = {MaxSentences}");
            sb.AppendLine("==================");
            return sb.ToString();
        }
    }
}
